const header = document.querySelector("header");
let oldScroll = 0;

document.addEventListener("scroll", () => {
    if (oldScroll < window.scrollY) {
        header.classList.add("hidden");
    } else {
        header.classList.remove("hidden");
    }
    oldScroll = window.scrollY;
});

var elem = document.querySelector('.main-carousel');
var flkty = new Flickity(elem, {
    cellAlign: 'left',
    contain: true,
    wrapAround: true,
    setGallerySize: false
});

let wrpflk = new Flickity(".carousel3", { wrapAround: true });
let frscflk = new Flickity(".carousel4", { cellAlign: 'left', freeScroll: true });
let apflk = new Flickity(".carousel5", { wrapAround: true, autoPlay: 1500 });
let isselflk = new Flickity(".carousel6", { wrapAround: true });
let pdflk = new Flickity(".carousel7", { wrapAround: true });
let fsflk = new Flickity(".carousel8", { wrapAround: true });

let footer = document.querySelector("footer")

let texts = document.querySelectorAll(".aText");
document.addEventListener("scroll", () => {
    texts.forEach(text => {
        if (text.getBoundingClientRect().top < 650) {
            text.style.opacity = 1;
            text.style.animation = "toUp .5s ease-out forwards"
        } else {
            text.style.animation = "toDown .5s ease-out forwards"
        }
    });
    if (document.querySelector("section.style").getBoundingClientRect().top < 800) {
        footer.style.opacity = 1
    } else { footer.style.opacity = 0}
});



const cdn = document.querySelector(".cdn");
const htmlCarousel = document.querySelector(".html");
const jsSu = document.querySelector(".js");

cdn.addEventListener("click", () => {
    navigator.clipboard.writeText(
        `<link rel="stylesheet" href="https://unpkg.com/flickity@2/dist/flickity.min.css">
<script src="https://unpkg.com/flickity@2/dist/flickity.pkgd.min.js"></script>`
    );
});

htmlCarousel.addEventListener("click", () => {
    navigator.clipboard.writeText(
        `<div class="main-carousel">
    <div class="carousel-cell">...</div>
    <div class="carousel-cell">...</div>
    <div class="carousel-cell">...</div>
    ...
</div>`
    );
});

jsSu.addEventListener("click", () => {
    navigator.clipboard.writeText(
        `document.addEventListener("DOMContentLoaded", () => {
    var elem = document.querySelector('.carousel');
    new Flickity(elem, {
        cellAlign: 'left',
        contain: true
    });
});`
    );
});



const copy = document.querySelector(".copy")
const mhover = document.querySelectorAll(".mhover")

document.addEventListener("mousemove", (e) => {
    copy.style.left = `${e.clientX}px`
    copy.style.top = `${window.scrollY + e.clientY}px`
})

mhover.forEach(e => {
    e.addEventListener("mouseover", () => {
        copy.style.opacity = 1
    })
    e.addEventListener("mouseleave", () => {
        copy.style.opacity = 0
    })
})




let pageInterval = setInterval(pageLoaded, 500);
let pageload = document.querySelector("#loader-container")
let loadAp = document.querySelectorAll(".loadAp")

function pageLoaded() {
    console.log(pageload.style.display)
    if (pageload.style.display === "none") {
        clearInterval(pageInterval)
        document.querySelector(".disc").style.animation = "heroToUp .35s ease-out .2s forwards"
        document.querySelector(".by").style.animation = "heroToDown .35s ease-out .45s forwards"
        document.querySelector("body").style.background = "var(--white)"
        document.querySelector(".heroHeader .center .text h1").style.opacity = 1
        setTimeout(() => {header.classList.remove("hidden");
            loadAp.forEach(e => {
            e.style.opacity = 1
        })},350)
        setTimeout(() => {document.querySelector(".heroHeader .center img").style.opacity = 1}, 800)
    }
}


